﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace Loxx
{
  public class LoxxMacro
  {
    public LoxxMacro()
    {
      Name = GetType().Name;
    }
    public string Name { get; set; } = "";
    public string Description { get; set; } = "";
    public virtual void Execute(Loxx.Application app) { }
  }

  public class LoxxFormatter
  {
    public LoxxFormatter()
    {
      Name = GetType().Name;
    }
    public string Name { get; set; } = "";
    public string Description { get; set; } = "";
    public virtual LineFormatInfo[] Format(string s, int width) { return new LineFormatInfo[1] { new LineFormatInfo() { Content = s } }; }
  }

  [Flags]
  public enum ViewEvents
  {
    Close = 1,
    LineFormat = 2,
    PopupFormatFormat = 2,
  }

  // generated section: Event classes
  public class ViewEventDispatcher 
  {
    /// <summary>
    /// Notification about a file open.
    /// </summary>
    public delegate void OnOpen(string FileName);
    
    /// <summary>
    /// Called for getting the popup display content.
    /// </summary>
    public delegate LineFormatInfo[] DisplayPopup(string LineContent, long Line, int Width);
    
    /// <summary>
    /// Display a single line.
    /// You can handle this event for changing the visible output (change content and colors).
    /// </summary>
    public delegate LineFormatInfo DisplayLine(string LineContent, long Line);
    
    /// <summary>
    /// Notification about a file close.
    /// Return false if you want to disable a close and / or store persistent information.
    /// </summary>
    public delegate bool OnClose();
    
    /// <summary>
    /// Will be called if a highlight filter is triggered with a configured &quot;ExtensionTrigger&quot;-setting.
    /// </summary>
    public delegate void OnExpressionTrigger(long Offset);
    
    /// <summary>
    /// Notification about a file change.
    /// A change notification is send, when lines have been added to a file and no reload was detected.
    /// </summary>
    public delegate void OnFileChange();
    
    /// <summary>
    /// Notification about a file reload. 
    /// A reload is typically triggered if a file deletion or a decremented of the size is detected. 
    /// </summary>
    public delegate void OnFileReload();
    
    
    
    /// <summary>
    /// Notification about a file open.
    /// </summary>
    public event OnOpen _OnOpen;
    
    /// <summary>
    /// Called for getting the popup display content.
    /// </summary>
    public event DisplayPopup _DisplayPopup;
    
    /// <summary>
    /// Display a single line.
    /// You can handle this event for changing the visible output (change content and colors).
    /// </summary>
    public event DisplayLine _DisplayLine;
    
    /// <summary>
    /// Notification about a file close.
    /// Return false if you want to disable a close and / or store persistent information.
    /// </summary>
    public event OnClose _OnClose;
    
    /// <summary>
    /// Will be called if a highlight filter is triggered with a configured &quot;ExtensionTrigger&quot;-setting.
    /// </summary>
    public event OnExpressionTrigger _OnExpressionTrigger;
    
    /// <summary>
    /// Notification about a file change.
    /// A change notification is send, when lines have been added to a file and no reload was detected.
    /// </summary>
    public event OnFileChange _OnFileChange;
    
    /// <summary>
    /// Notification about a file reload. 
    /// A reload is typically triggered if a file deletion or a decremented of the size is detected. 
    /// </summary>
    public event OnFileReload _OnFileReload;
    
    
    
    public void TriggerOnOpen(string FileName)
    {
      if(_OnOpen != null)
      {
        _OnOpen(FileName);
      }
    }
    
    public bool hasOnOpenHandler()
    {
      return _OnOpen != null;
    }
    public LineFormatInfo[] TriggerDisplayPopup(string LineContent, long Line, int Width)
    {
      if(_DisplayPopup != null)
      {
        return _DisplayPopup(LineContent, Line, Width);
      }
      return null;
    }
    
    public bool hasDisplayPopupHandler()
    {
      return _DisplayPopup != null;
    }
    public LineFormatInfo TriggerDisplayLine(string LineContent, long Line)
    {
      if(_DisplayLine != null)
      {
        return _DisplayLine(LineContent, Line);
      }
      return null;
    }
    
    public bool hasDisplayLineHandler()
    {
      return _DisplayLine != null;
    }
    public bool TriggerOnClose()
    {
      if(_OnClose != null)
      {
        return _OnClose();
      }
      return true;
    }
    
    public bool hasOnCloseHandler()
    {
      return _OnClose != null;
    }
    public void TriggerOnExpressionTrigger(long Offset)
    {
      if(_OnExpressionTrigger != null)
      {
        _OnExpressionTrigger(Offset);
      }
    }
    
    public bool hasOnExpressionTriggerHandler()
    {
      return _OnExpressionTrigger != null;
    }
    public void TriggerOnFileChange()
    {
      if(_OnFileChange != null)
      {
        _OnFileChange();
      }
    }
    
    public bool hasOnFileChangeHandler()
    {
      return _OnFileChange != null;
    }
    public void TriggerOnFileReload()
    {
      if(_OnFileReload != null)
      {
        _OnFileReload();
      }
    }
    
    public bool hasOnFileReloadHandler()
    {
      return _OnFileReload != null;
    }
    
    public View RelatedView {get;set;}
    
  }
  // generated section: Event classes


  public class ViewExtender
  {

    public virtual void Connect(ViewEventDispatcher dispatcher) { }
    public virtual void Disconnect() { }

    void OnOpen(string fileName)
    {
      // file is opened - so may be you want to load an IP address mapping or similar.
    }
    bool Close()
    {
      // file will be closed -- you can prevent a close by returning false.
      return true;
    }

    public String FilePattern = "*.*";

    public String Name = "";

    public View _View;

    public Application _Application;
  }

  /// <summary>
  /// Base class for value extraction. Registered providers will be called from the framework for watched values
  /// </summary>
  public class ValueProvider
  {
    public string TransformValue(string LineContent) { return ""; }
  }

}
