///////////////////////////////////////////////////////////////////////////////////////////////////
/// DO NOT STORE YOUR MACROS IN THIS FILE!! 
/// THIS FILE WILL BE OVERWRITTEN BY SOFTWARE UPDATES 
///////////////////////////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Globalization;
using Loxx;

/// <summary>
/// Find all matches of SVERITY*Error and show a value in the value display
/// </summary>
public class CSCheckErrors : LoxxMacro
{
  public CSCheckErrors()
  {
    Description = "CSCheckErrors";
  }

  public override void Execute(Application app)
  {
    var view = app.ActiveView;
    if (view != null)
    {
      uint count = view.Find("SEVERITY*Error", true, SearchType.InternPatterns, CollectTarget.Strings, true);
      view.RemoveAllValues();
      var value = view.CreateValue();
      value.Name = "Errors";
      value.Value = count.ToString();
      value.Type = count > 0 ? MessageType.Error : MessageType.Success;
      value.ShowIcon = true;
      if (count > 0)
      {
        value.Line = view.GetFindMatch(0);
      }
      view.AddValue(value);
    }
  }
}

