///////////////////////////////////////////////////////////////////////////////////////////////////
/// DO NOT STORE YOUR MACROS IN THIS FILE!! 
/// THIS FILE WILL BE OVERWRITTEN BY SOFTWARE UPDATES 
///////////////////////////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Loxx;
using System.Globalization;
using System.Drawing;
using System.ComponentModel;

/// <summary>
///  Sample macro showing a simple XY graph with a sinus graph 
/// </summary>
public class Graphic_XY_Chart : LoxxMacro
{
  public Graphic_XY_Chart()
  {
    Name = GetType().Name;
    Description = "Sample showing a simple XY-graph";
  }

  public override void Execute(Loxx.Application app)
  {
    var data = new GraphData() { Title = "Sinus * Cos function 2 cycles" };
    data.XYGraphData = new XYRow[1] { new XYRow() };
    data.XYGraphData[0].Values = new XYValue[1000];

    for (int i = 0; i < 1000; i++)
    {
      double x = i * (2 * Math.PI / 1000.0);
      data.XYGraphData[0].Values[i] = new XYValue() { X = (double)i, Y = Math.Sin(x) * 2.0 * Math.Cos(5 * x) };
    }
    // data.XYGraphData[0].Color = 0x0000FF;
    data.XAxis = new Axis() { Label = "time (seconds)", ShowScalings = true };
    data.YAxis = new Axis() { Label = "ml/s", ShowScalings = true, AutoMax = true, Max = 5.2, AutoMin = false, Min = -2.0 };

    app.ShowGraph(0, data);
  }
}


public class CS_ColorTest : LoxxMacro
{
  public CS_ColorTest()
  {
    Name = GetType().Name;
    Description = "Test showing all colors";
  }

  public override void Execute(Loxx.Application app)
  {
    app.WriteMessage("Hello");
  }
}


/// <summary>
/// Sample showing multiple lines in a XY chart 
/// </summary>
public class Graphic_Multi_XY : LoxxMacro
{
  public Graphic_Multi_XY()
  {
    Name = GetType().Name;
    Description = "Sample showing a simple XY-graph";
  }

  public override void Execute(Loxx.Application app)
  {
    var data = new GraphData();

    uint[] colors = new uint[5] { 0xFF8080, 0x0000FF, 0x00FF00, 0x00C0FF, 0xFFFF00 };
    data.XYGraphData = new XYRow[5];

    const int xcount = 2000;
    for (int j = 0; j < 5; j++)
    {
      data.XYGraphData[j] = new XYRow() { Values = new XYValue[xcount], Color = colors[j] };
      for (int i = 0; i < xcount; i++)
      {
        var x = i * (2 * Math.PI / (double)xcount);
        data.XYGraphData[j].Values[i] = new XYValue() { X = x, Y = j / 2.2 + Math.Sin(x * Math.Cos(j * j + x * j)) };
      }
    }
    data.Title = "Multi XY Sample";
    data.XAxis = new Axis() { Label = "time (seconds)", ShowScalings = true };
    data.YAxis = new Axis() { Label = "ml/s", ShowScalings = true, AutoMax = false, Max = 3.2, AutoMin = false, Min = -1.1 };
    app.ShowGraph(0, data);
    app.UpdateWindow();
  }
}


/// <summary>
/// Show a simple bar graph 
/// </summary>
public class Graphic_SimpleBarChart : LoxxMacro
{
  public Graphic_SimpleBarChart()
  {
    Name = GetType().Name;
    Description = "Sample showing a simple bar chart";
  }

  public override void Execute(Loxx.Application app)
  {
    // data is an array of 6 values ...
    SingleBarValue[] data = new SingleBarValue[7] {
      new SingleBarValue(){Value = 13.7, Label ="USA", Color=0xFF8040},
      new SingleBarValue(){Value = 12.3, Label ="Germany", Color=0x4040FF},
      new SingleBarValue(){Value = 8.7, Label ="France", Color=0xFF8080},
      new SingleBarValue(){Value = 6.1, Label ="Italy", Color=0x00FFFF},
      new SingleBarValue(){Value = 2.1, Label ="England", Color=0xFF40C0},
      new SingleBarValue(){Value = 1.3, Label ="Sweden", Color=0X408040},
      new SingleBarValue(){Value = 13.6, Label ="Others", Color=0x808080}
    };
    var graphData = new GraphData()
    {
      SingleBarData = new SingleBarRow() { Values = data },
      Title = "Simple bar chart sample",
      ShowValues = false,
    };
    graphData.YAxis = new Axis() { Label = "ml/s", ShowScalings = true, AutoMax = true, Max = 14.2, AutoMin = false, Min = -1.1 };
    graphData.XAxis = new Axis() { Label = "Values per country (relative)", RowLabels = new String[7] };
    for (int i = 0; i < graphData.SingleBarData.Values.Length; i++)
    {
      graphData.XAxis.RowLabels[i] = graphData.SingleBarData.Values[i].Label + " (" + graphData.SingleBarData.Values[i].Value.ToString() + ")";
    }
    app.ShowGraph(0, graphData);
  }
}

/// <summary>
/// Show a multi bar graph
/// </summary>
public class Graphic_MultiBars : LoxxMacro
{
  public Graphic_MultiBars()
  {
    Name = GetType().Name;
    Description = "Sample showing a multi bar graph";
  }
  public override void Execute(Loxx.Application app)
  {
    double[][] data = new double[4][]
    {
        new double[] { 10.7, 8.3, 4, 2.7, 1.7, 0.9 },
        new double[] { 6.1, 4.5, 3, 2.7, 2.1, 1.8 },
        new double[] { 4.4, 2.2, 4.8, 3.3, 1.2, 0.1},
        new double[] { 5.1, 2.5, 1.7, 1.8, 0.7, 0.3 }
    };

    string[] names = new string[4] { "USA", "Germany", "France", "Italy" };
    uint[] colors = new uint[4] { 0xFF2020, 0x4040C0, 0x80C040, 0x00C0C0 };

    var graphData = new GraphData() { Title = "Sample showing a multi bar graph" };

    graphData.MultiBarData = new MultiBarRow[4];
    for (int i = 0; i < names.Length; i++)
    {
      graphData.MultiBarData[i] = new MultiBarRow() { Values = data[i], Name = names[i], Color = colors[i] };
    }
    graphData.ShowValues = true;
    graphData.Type = GraphType.MultiBarChart;
    graphData.XAxis = new Axis() { Label = "Years" };
    graphData.YAxis = new Axis() { Label = "Amount" };
    graphData.XAxis.RowLabels = new string[6] { "2022", "2025", "2027", "2021", "2021", "2021" };

    app.ShowGraph(0, graphData);
  }
}
